/*
 * Lachesis, an IRCRPG combat engine - Channel management
 * Copyright 2002 M. Dannis
 *
 * This program is free software; please see the file COPYING for details.
 */

#include <string.h>
#include <stdio.h>
#include "root.h"
#include "channel.h"
#include "../irc.h"
#include "../ircint.h"
#include "../auth.h"
#include "../utils.h"
#include "../config.h"

extern char *irc_curchan;
extern IRC_PCL irc_channels;

#ifndef RPGSERV
extern Cmd_PMod cmd_modules;

void Cmd_channel_Init()
{
  Cmd_Alloc(&Cmd_Channel_Root, "channel", CMD_AUTH_MASTER);
}
#endif

void Cmd_Channel_Root(void *ticket, int auth, const char *str)
{
  if (str==NULL||!*str) {
    if (*irc_curchan)
      Auth_CmdResult(ticket, auth, Util_Format("Current channel is %s",
					       irc_curchan, NULL, NULL));
    else
      Auth_CmdResult(ticket, auth, "No current channel.");
    return ;
  }
  const char *cmd, *data;
  data = str;
  cmd = Util_Separate(&data, 32);
  if (!cmd) {
    cmd = data;
    data = NULL;
  }
  if (strcasecmp(cmd, "JOIN")==0) {
    if (data==NULL||!*data)
      Auth_CmdResult(ticket, auth, "Join what?");
    else {
      cmd = Util_Separate(&data, 32);
      if (!cmd)
	IRC_Join(data, NULL);
      else
	if (!*data)
	  IRC_Join(cmd, NULL);
	else
	  IRC_Join(cmd, data);
    }
    return ;
  }
  if (strcasecmp(cmd, "PART")==0) {
    if (data&&*data) {
      cmd = Util_Separate(&data, 32);
      if (cmd==NULL) {
	cmd = data;
	data = NULL;
      }
      IRC_Part(cmd, data);
    }
    else {
      if (irc_curchan!=NULL&&*irc_curchan)
	IRC_Part(irc_curchan, NULL);
      else {
	if (irc_channels!=NULL) {  // This shouldn't happen.
	  IRC_Part(irc_channels->chan, NULL);
	  if (irc_channels!=NULL)
	    Util_Copy(irc_curchan, irc_channels->chan, ALLOC_CHAN);
	} else
	  Auth_CmdResult(ticket, auth, "Not joined to a channel.");
      }
    }
    return ;
  }
  if (strcasecmp(cmd, "LIST")==0) {
    if (irc_channels==NULL) {
      Auth_CmdResult(ticket, auth, "Not joined to a channel.");
      return ;
    }
    if (irc_channels->GetNext()==NULL) {
      Auth_CmdResult(ticket, auth, Util_Format("Joined to channel %s.",
					       irc_channels->chan, NULL, 
					       NULL));
      return ;
    }
    IRC_PCL temp;
    char out[ALLOC_BUFFER];
    temp = irc_channels->GetNext();
    snprintf(out, ALLOC_BUFFER, "Joined to channels %s", irc_channels->chan);
    while (temp->GetNext()) {
      Util_Copy(out, Util_Format("%s, %s", out, temp->chan, NULL), 
		ALLOC_BUFFER);
      temp=temp->GetNext();
    }
    Auth_CmdResult(ticket, auth, Util_Format("%s and %s.", out, temp->chan,
					     NULL)
		   );
    return ;
  }
  Auth_CmdResult(ticket, auth, Util_Format("Unrecognized command: %s", cmd,
					   NULL, NULL)
		 );
}
