/*
 * Lachesis, an IRCRPG combat engine - Root command handler.
 * Copyright 2002-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <stdio.h>
#include "root.h"
#include "../utils.h"
#include "../auth.h"
#include "../config.h"
#include "modinc.h"  
// Generated by mkmoddep for module initialization prototyping.

static char* id="@(#) $Id: root.cc,v 1.1.1.1 2004/01/16 07:28:15 lachesis Exp $";

Cmd_PMod cmd_modules;

void Cmd_Init()
{
#ifdef DEBUG
  Util_Eputs("DEBUG - Cmd_Init called\n");
#endif
  cmd_modules = NULL;
#include "modinit.lst"  
  // Generated by mkmoddep for module initialization.
}

void Cmd_Alloc(void (*f)(void *, int, const char *), const char *cmd, int auth)
{
  Cmd_PMod temp;
  if (cmd_modules) {
    for (temp=cmd_modules;temp->next;temp=temp->next) ;
    temp->next = new Cmd_TMod;
    temp = temp->next;
  } else
    temp = cmd_modules = new Cmd_TMod;
  temp->f = f;
  Util_Copy(temp->cmd, cmd, ALLOC_CMD);
  temp->auth = auth;
  temp->next=NULL;
}

void Cmd_Cleanup()
{
#ifdef DEBUG
  Util_Eputs("DEBUG - Cmd_Cleanup called\n");
#endif
  Cmd_PMod temp;
  while (cmd_modules) {
    temp=cmd_modules;
    cmd_modules=cmd_modules->next;
    delete [] temp;
  }
}

void Cmd_Root(void *ticket, int auth, const char *str)
{
  const char *data, *cmd;
  Cmd_PMod temp;

#ifdef DEBUG
  Util_Eputs("DEBUG - Cmd_Root called\n");
#endif
  data = str;
  cmd = Util_Separate(&data, 32);
  if (cmd==NULL) {
    cmd = data;
    data = NULL;
  }
  for (temp=cmd_modules;temp;temp=temp->next)
    if (strcasecmp(temp->cmd, cmd)==0) {
      if (auth<temp->auth)
	Auth_CmdResult(ticket, auth, Util_FormatD("You are not authorized to use %s commands.", cmd, NULL, NULL));
      else
	(*(temp->f))(ticket, auth, data);
      return ;
    }
  Auth_CmdResult(ticket, auth, 
		 Util_FormatD("I do not recognize %s as a command.", cmd,
			      NULL, NULL)
		 );
}
