/*
 * Lachesis low-level IRC Interface API
 * Copyright 2002-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _IRCINT_H_
#define _IRCINT_H_

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif

const char * IRC_VersionInfo();

void IRC_Connect(const char *server, const int port, const char *nick, const char *user, const char *name);

void IRC_Userhost(const char *target);
void IRC_Quote(const char *str, TF priority);
void IRC_Notice(const char *target, const char *);
void IRC_Part(const char *channel, const char *);
void IRC_CTCP(const char *target, const char *command, const char *data);
void IRC_CTCPReply(const char *target, const char *command, const char *data);
void IRC_Nick(const char *);
void IRC_Public(const char *channel, const char *);
void IRC_Action(const char *channel, const char *);
void IRC_MSG(const char *target, const char *);
void IRC_Describe(const char *target, const char *);
void IRC_Wallop(const char *);
void IRC_Join(const char *channel, const char *key);
void IRC_Quit(const char *);
void IRC_Disconnect(TF flag);
TF IRC_IsConnected();

const char * IRC_GetNick();
const char * IRC_GetHost();

void * IRC_DCCChatSend(const char *);
void IRC_DCCChatAccept(void *);
void IRC_DCCChatReject(void *);
void IRC_DCCChatMessage(void *, const char *);
void IRC_DCCChatClose(void *);

const char * IRC_DCCGetNick(void *);

void IRC_DCCSend(const char *, const char *fn);

// NOTE: The following functions use an internal buffer to store the
//       string; if you need to keep it, copy it to another location.
const char * IRC_HostmaskNick(const char *);
const char * IRC_HostmaskUser(const char *);
const char * IRC_HostmaskHost(const char *);

void LowIrcCleanup();

#ifdef __cplusplus
}
#endif

#endif

/* @(#) $Id: ircint.h,v 1.1.1.1 2004/01/16 07:28:15 lachesis Exp $ */
