/*
 * Lachesis, an IRCRPG combat engine - Bot action command handler.
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 * Note: This is also used as part of RPGServ.
 */

#ifndef _CMD_AUTHCMD_H_
#define _CMD_AUTHCMD_H_

const char *CMD_AUTHCMD_USERHELP[] =
  { "LOGIN", "AUTH LOGIN authenticates users.",
    "LOGOUT", "AUTH LOGOUT will log out of an account.",
    "PASSWD", NULL,
    "PASSWORD", "AUTH PASSWORD <old> <new> will change your password. You must provide the correct current password. You may also use AUTH PASSWD <old> <new>.",
    NULL, "The authentication system provides access to account settings, as well as logging into and out of an account.",
  };

const char *CMD_AUTHCMD_SETHELP[] =
  { "SECURITY", "AUTH SET SECURITY [ON|OFF] - Sets or queries the high security option.\nBy default, hostmasks aren't completely trusted; setting this option to OFF will allow any matching hostmask when users aren't seen in channels.",
    "USEMSG", "AUTH SET USEMSG [ON|OFF] - Sets or queries the MSG option.\nBy default, when no DCC CHAT connection is present, information is sent to the user using notices. Setting this option to ON will send using MSG instead.",
    "SOUNDS", "AUTH SET SOUNDS [ON|OFF] - Sets or queries the sound option.\nThis currently does not affect anything.",
    NULL, "AUTH SET maintains account settings. The following options are available:\n  SECURITY\n  USEMSG\n  SOUNDS",
  };

const char *CMD_AUTHCMD_NONEHELP = "Available commands:\n  AUTH LOGIN <acct> <pass>\n    Log into a user account.\n  HELP\n    Display this message.";

#ifndef RPGSERV
void Cmd_authcmd_Init();
#endif
void Cmd_Auth_Root(void *, int, const char *);
void Cmd_Auth_HandleLogin(void *, int, const char *);
void Cmd_Auth_HandleHelp(void *, int, const char *);
void Cmd_Auth_HandlePasswd(void *, int, const char *);
void Cmd_Auth_HandleSecurity(void *, int, const char *);
void Cmd_Auth_HandleSet(void *, int, const char *);
#endif
