/*
 * Lachesis, an IRCRPG combat engine - Dice roller
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 *
 * Note: This is a standalone dice roll for user benefit. It is not directly
 * used by the combat engine.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "root.h"
#include "roll.h"
#include "../auth.h"
#include "../utils.h"
#include "../types.h"
#include "../alloc.h"

#ifndef RPGSERV
extern Cmd_PMod cmd_modules;

void Cmd_roll_Init()
{
  Cmd_Alloc(&Cmd_Roll_Root, "roll", CMD_AUTH_USER);
}
#endif

void Cmd_Roll_Root(void *ticket, int auth, const char *str)
{
  unsigned long count, magnitude;
  long floor;
  char tstr[32];
  const char *temp, *ptr = str;
  if (str==NULL||!*str)
    Auth_CmdResult(ticket, auth, "Usage: roll [#]d#[{+#|-#}]");
  else {
    Util_SepTo(tstr, 32, &ptr, 'd');
    if (ptr==NULL) {
      Auth_CmdResult(ticket, auth, "Unrecognized roll format.");
      return ;
    }
    if (*tstr) {
      if (*tstr<'0'||*tstr>'9') {
	Auth_CmdResult(ticket, auth, "Unrecognized roll format.");
	return ;
      } else
	count = strtoul(tstr, NULL, 10);
    } else
      count = 1;
    temp = strchr(ptr, '+');
    if (temp==NULL)
      temp = strchr(ptr, '-');
    if (temp==NULL) {
      if (ptr[0]<'0'||ptr[0]>'9') {
	Auth_CmdResult(ticket, auth, "Unrecognized roll format.");
	return ;
      }
      magnitude = strtoul(ptr, NULL, 10);
      Cmd_Roll_DoRoll(ticket, auth, count, magnitude, 1);
    } else {
      Util_SepTo(tstr, 32, &ptr, *temp);
      if (tstr[0]<'0'||tstr[0]>'9'||ptr[0]<'0'||ptr[0]>'9') {
	Auth_CmdResult(ticket, auth, "Unrecognized roll format.");
	return ;
      }
      magnitude = strtoul(tstr, NULL, 10);
      floor = strtol(ptr-1, NULL, 10);
      Cmd_Roll_DoRoll(ticket, auth, count, magnitude, 1+floor);
    }
  }
}

void Cmd_Roll_DoRoll(void *ticket, int auth, unsigned long count, 
		     unsigned long magnitude, long floor)
{
  unsigned long excess, loop, result;

  if (count==0||count>4) {
    Auth_CmdResult(ticket, auth, "Invalid count.");
    return ;
  }
  if (magnitude<2) {
    Auth_CmdResult(ticket, auth, "Invalid magnitude.");
    return ;
  }
  for (loop=0;loop<count;loop++) {
    excess = RAND_MAX / magnitude;
    if (excess==0) {
      Auth_CmdResult(ticket, auth, "Magnitude exceeds RAND_MAX.");
      return ;
    }
    do
      result = rand() / excess;
    while (result>=magnitude);
    if (floor<0) {
      unsigned long sub = (unsigned long)(-1*floor);
      if (sub>result)
	Auth_CmdResult(ticket, auth,
		       Util_Format("Roll %d: -%d", loop+1, sub-result, NULL));
      else
	Auth_CmdResult(ticket, auth,
		       Util_Format("Roll %d: %d", loop+1, result-sub, NULL));
    } else
      Auth_CmdResult(ticket, auth,
		     Util_Format("Roll %d: %d", loop+1, 
				 result+(unsigned long)(floor), NULL));
  }
}
