/*
 * Lachesis, an IRCRPG combat engine - Root command handler.
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 */

#ifndef _CMD_ROOT_H_
#define _CMD_ROOT_H_

#include "../lachesis.h"

#define ALLOC_CMD       11

#define CMD_AUTH_NONE   0
#define CMD_AUTH_USER   1
#define CMD_AUTH_MASTER 2

#ifndef RPGSERV
typedef struct tag_cmd_mod {
  void (*f)(void *, int, const char *);
  char cmd[ALLOC_CMD];
  int auth;
  struct tag_cmd_mod *next;
#ifdef __cplusplus
  tag_cmd_mod() { f = NULL;  auth = CMD_AUTH_USER; }
#endif
} Cmd_TMod, *Cmd_PMod;

void Cmd_Init();
void Cmd_Cleanup();
void Cmd_Alloc(void (*f)(void *, int, const char *), const char *, int);
void Cmd_Root(void *, int, const char *);
#endif

#endif
