/*
 * Lachesis - Interface to Parsecfg
 * Copyright 2002 M. Dennis
 *
 * This program is free software; please see the file COPYING for details.
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <stdio.h>
#include "auth.h"
#include "lachesis.h"
#include "alloc.h"
#include "types.h"
#include "utils.h"

extern CmdOpts options;

TF LD_AuthGetUsers()
{
  struct dirent *dirlist, *flglist;
  DIR *dir, *flg;
  FILE *in;
  Auth_PUser tuser;
  char *input = NULL, *masteracct = NULL;
  char acct[ALLOC_ACCT], pass[ALLOC_PASS], path[ALLOC_MINIBUFFER];
  size_t len = 0;
  bool tbl;
  in = fopen("data/users/master", "r");
  if (in!=NULL) {
    Util_Getline(&masteracct, &len, in);
    *strchr(masteracct, '\n') = '\0';
    fclose(in);
  } else {
    fputs("LoadData: No Master account specified! Failed...\n", stderr);
    return FALSE;
  }
  len = 0;
  dir = opendir("data/users");
  if (dir==NULL) {
    fprintf(stderr, "LoadData: Unexpected error from opendir: %m\n");
    free (masteracct);
    return FALSE;
  }
  while ((dirlist=readdir(dir))!=NULL) {
    if (dirlist->d_type!=DT_DIR || strcmp(dirlist->d_name, ".")==0 || 
	strcmp(dirlist->d_name, "..")==0)
      continue;
    Util_Copy(acct, dirlist->d_name, ALLOC_ACCT);
    snprintf(path, ALLOC_MINIBUFFER, "data/users/%s/password", acct);
    in = fopen(path, "r");
    if (in==NULL) {
      fprintf(stderr, "LoadData: Error retrieving password for %s: %m\n",
	      acct);
      free (masteracct);
      return FALSE;
    }
    Util_Getline(&input, &len, in);
    *strchr(input, '\n') = '\0';
    fclose(in);
    tbl = strcasecmp(acct, masteracct)==0;
    tuser = new Auth_TUser(acct, input, tbl!=FALSE);
    if (tuser!=NULL) {
      TF nosec = FALSE, usemsg = FALSE, nosounds = FALSE, debug = FALSE;
      snprintf(path, ALLOC_MINIBUFFER, "data/users/%s/flags", acct);
      flg = opendir(path);
      while((flglist=readdir(flg))!=NULL) {
	if (flglist->d_type!=DT_REG)
	  continue;
	if (strcmp(flglist->d_name, "nosec")==0) {
	  nosec = TRUE;
	  continue;
	}
	if (strcmp(flglist->d_name, "usemsg")==0) {
	  usemsg = TRUE;
	  continue;
	}
	if (strcmp(flglist->d_name, "nosounds")==0) {
	  nosounds = TRUE;
	  continue;
	}
	if (strcmp(flglist->d_name, "debug")==0)
	  debug = TRUE;
      }
      tuser->security = !nosec;
      tuser->usemsg = usemsg;
      tuser->sounds = !nosounds;
      tuser->debug = debug;
    }
  }
  free(masteracct);
  if (Auth_TUser::GetMaster()==NULL) {
    fputs("LoadData: No account is master! Failed...\n", stderr);
    return FALSE;
  }
  return TRUE;
}

void LD_AuthDumpUsers()
{
  // Eventually, this may handle saving the userlist.
  // 20021230 Karinu - No. We perform all changes as made, so there is no
  // reason to save the userlist on exit.
  Auth_TUser::FlushList();
}

void LD_SetSecurity(const char *acct, TF setting)
{
  char path[ALLOC_MINIBUFFER];
  snprintf(path, ALLOC_MINIBUFFER, "data/users/%s/flags/nosec", acct);
  if (setting)
    unlink(path);
  else
    link("data/empty", path);
}

void LD_SetUseMSG(const char *acct, TF setting)
{
  char path[ALLOC_MINIBUFFER];
  snprintf(path, ALLOC_MINIBUFFER, "data/users/%s/flags/usemsg", acct);
  if (setting)
    link("data/empty", path);
  else
    unlink(path);
}

void LD_SetSounds(const char *acct, TF setting)
{
  char path[ALLOC_MINIBUFFER];
  snprintf(path, ALLOC_MINIBUFFER, "data/users/%s/flags/nosounds", acct);
  if (setting)
    unlink(path);
  else
    link("data/empty", path);
}

void LD_SetPassword(const char *acct, const char *pass)
{
  // Note: Validity check must occur before this call is made.
  char path[ALLOC_MINIBUFFER];
  FILE *out;
  int c=0;
  snprintf(path, ALLOC_MINIBUFFER, "data/users/%s/password", acct);
  do {
    c++;
    if (c>10) {
      fprintf(stderr, "File error: unable to write password: %m\n");
      return ;
    }
    unlink(path);
  } while ((out=fopen(path, "wx"))==NULL);
  fprintf(out, "%s\n", pass);
  fclose(out);
}

