/*
 * Lachesis - Channel list for high-level IRC interface
 * Copyright 2002-2004 M. Dennis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _IRCCL_H_
#define _IRCCL_H_

#include "alloc.h"
#include "types.h"
#include "utils.h"

typedef class IRC_TCL {
 private:
  IRC_TCL *next, *prev;
 public:
  char chan[ALLOC_CHAN];
  inline IRC_TCL(IRC_TCL *top) 
    { 
#ifdef DEBUG
      Util_Eputs("DEBUG - IRC_TCL ctor called\n");
#endif
      prev = NULL; next = top; if (top!=NULL) top->prev = this; }
  static inline void Delete(IRC_TCL *cl) 
    { 
#ifdef DEBUG
      Util_Eputs("DEBUG - IRC_TCL::Delete called\n");
#endif
      if (cl->next!=NULL)
	cl->next->prev = cl->prev;
      if (cl->prev!=NULL)
	cl->prev->next = cl->next;
      delete [] cl;
    }
  inline IRC_TCL * GetNext() { return next; }
  static inline void Flush(IRC_TCL *top)
    { 
#ifdef DEBUG
      Util_Eputs("DEBUG - IRC_TCL::Flush called\n");
#endif
      if (top->next!=NULL) Flush(top->next); Delete(top); }
} *IRC_PCL;

#endif

/* @(#) $Id$ */
